function datload(filename)
% DATLOAD - loads FDC model-definition parameters from file
%
% DATLOAD calls FDCLOAD to load files of type *.DAT (model definition
% files). Used for initialization of the Simulink models from the FDC
% toolbox.
%
% Usage:
% ======
% datload
%    will open a dialog box with all available DAT-files in the used 
%    data-directory. Normally, the FDC data-directory will be used as 
%    starting point, but if that directory is not available DATLOAD will 
%    display a warning message, and use the current working directory
%    instead.
%
% datload('filename')
%    will do the same, except 'filename.dat' will be used as default
%    filename (this can still be overruled by selecting a different file
%    from the load dialog).
%
% Note: Specifying a non-existing filename as default DAT-file does not
%    yield an error, unless one actually tries to open this non-existing
%    file from the load dialog. 
%
% See also FDCLOAD.

% Variables:
% ----------
% filename   used to store default filename (without extension; the complete
%             file becomes 'filename.dat')

if nargin == 0
  feval('fdcload','dat','model-definition data');
elseif nargin == 1
  feval('fdcload',[filesep filename '.dat'],'model-definition data');
end

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------